﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.Xrm.Sdk;
using PpmsDataService.ModelsEnumTypes;
using PpmsDataService.Models;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;

namespace PpmsDataService.V1.Mappers
{
    public class CareSiteMap
    {
        public static async Task<IQueryable<CareSite>> MapCareSites(List<ppms_caresite> ppmsCareSites, string mapRelatedType, PpmsContext context)
        {
            var careSites = new List<CareSite> { };
            foreach (var ppmsCareSite in ppmsCareSites)
            {
                //Gernal Info
                var careSite = new CareSite
                {
                    Name = ppmsCareSite.ppms_name,
                    Id = ppmsCareSite.Id
                };

                //Site Type Switch. 
                if (ppmsCareSite.ppms_sitetype != null)
                    switch (ppmsCareSite.ppms_sitetype.Value)
                    {
                        case (int)ppms_caresite_ppms_sitetype.CLC:
                            careSite.CareSiteType = CareSiteType.CLC;
                            break;
                        case (int)ppms_caresite_ppms_sitetype.Clinic:
                            careSite.CareSiteType = CareSiteType.Clinic;
                            break;
                        case (int)ppms_caresite_ppms_sitetype.CommunityLivingCenter:
                            careSite.CareSiteType = CareSiteType.CommunityLivingCenter;
                            break;
                        case (int)ppms_caresite_ppms_sitetype.Facility:
                            careSite.CareSiteType = CareSiteType.Facility;
                            break;
                        case (int)ppms_caresite_ppms_sitetype.IOC:
                            careSite.CareSiteType = CareSiteType.IOC;
                            break;
                        case (int)ppms_caresite_ppms_sitetype.MOC:
                            careSite.CareSiteType = CareSiteType.MOC;
                            break;
                        case (int)ppms_caresite_ppms_sitetype.NonVASite:
                            careSite.CareSiteType = CareSiteType.NonVaSite;
                            break;
                        case (int)ppms_caresite_ppms_sitetype.OC:
                            careSite.CareSiteType = CareSiteType.OC;
                            break;
                        case (int)ppms_caresite_ppms_sitetype.Pharmacy:
                            careSite.CareSiteType = CareSiteType.Pharmacy;
                            break;
                        case (int)ppms_caresite_ppms_sitetype.RRTP:
                            careSite.CareSiteType = CareSiteType.RRTP;
                            break;
                        case (int)ppms_caresite_ppms_sitetype.SpinalCordInjuryUnit:
                            careSite.CareSiteType = CareSiteType.SpinalCordInjuryUnit;
                            break;
                        case (int)ppms_caresite_ppms_sitetype.UnitDoseCart:
                            careSite.CareSiteType = CareSiteType.UnitDoseCart;
                            break;
                        case (int)ppms_caresite_ppms_sitetype.VAMC:
                            careSite.CareSiteType = CareSiteType.VAMC;
                            break;
                        case (int)ppms_caresite_ppms_sitetype.Ward:
                            careSite.CareSiteType = CareSiteType.Ward;
                            break;
                    }
                //VA Care Site Switch
                if (ppmsCareSite.ppms_VACareSite != null)
                    switch (ppmsCareSite.ppms_VACareSite.Value)
                    {
                        case true:
                            careSite.VaCareSite = true;

                            //VA Location Data
                            if (ppmsCareSite.ppms_visnid != null)
                                careSite.Visn = ppmsCareSite.ppms_visnid.Name;
                            if (ppmsCareSite.ppms_facilityid != null)
                                careSite.Facility = ppmsCareSite.ppms_facilityid.Name;
                            careSite.ParentStationNumber = ppmsCareSite.ppms_parentstationnumber;
                            careSite.StationName = ppmsCareSite.ppms_stationname;
                            careSite.MainSitePhone = ppmsCareSite.ppms_mainsitephone;

                            break;
                        case false:
                            careSite.VaCareSite = false;
                            break;
                    }

                if (ppmsCareSite.ppms_SiteContact != null)
                    careSite.SiteContactName = ppmsCareSite.ppms_SiteContact.Name;

                if (ppmsCareSite.ppms_organization != null)
                    careSite.OwningOrganizationName = ppmsCareSite.ppms_organization.Name;

                careSite.OtherName = ppmsCareSite.ppms_othername;

                //Is Handicap Accessible 
                if (ppmsCareSite.ppms_ishandicapaccessible != null)
                    switch (ppmsCareSite.ppms_ishandicapaccessible.Value)
                    {
                        case true:
                            careSite.IsHandicapAccessible = true;
                            break;
                        case false:
                            careSite.IsHandicapAccessible = false;
                            break;
                    }

                //Is External Switch
                if (ppmsCareSite.ppms_isexternal != null)
                    switch (ppmsCareSite.ppms_isexternal.Value)
                    {
                        case true:
                            careSite.IsExternal = true;
                            break;
                        case false:
                            careSite.IsExternal = false;
                            break;
                    }

                //Address Info
                careSite.Street = ppmsCareSite.ppms_address_line1;
                careSite.City = ppmsCareSite.ppms_address_city;
                if (ppmsCareSite.ppms_address_state != null)
                    careSite.State = ppmsCareSite.ppms_address_state.Name;
                careSite.ZipCode = ppmsCareSite.ppms_address_postalcode;
                careSite.County = ppmsCareSite.ppms_address_county;
                careSite.Country = ppmsCareSite.ppms_address_country;
                if (ppmsCareSite.ppms_latitude != null)
                {
                    careSite.Latitude = (decimal)ppmsCareSite.ppms_latitude;
                }
                if (ppmsCareSite.ppms_longitude != null)
                {
                    careSite.Longitude = (decimal)ppmsCareSite.ppms_longitude;
                }

                if (ppmsCareSite.ppms_geocoded != null)
                    switch (ppmsCareSite.ppms_geocoded.Value)
                    {
                        case true:
                            careSite.Geocoded = true;
                            break;
                        case false:
                            careSite.Geocoded = false;
                            break;
                    }

                //Extract the Related type from queryType string
                if (mapRelatedType.Contains("?$expand=OwningOrganization"))
                    mapRelatedType = "OwningOrganization";
                if (mapRelatedType.Contains("?$expand=SiteContact"))
                    mapRelatedType = "SiteContact";
                if (mapRelatedType.Contains("?$expand=Providers"))
                    mapRelatedType = "Providers";
                if (mapRelatedType.Contains("?$expand=ProviderServices"))
                    mapRelatedType = "ProviderServices";
                if (mapRelatedType.Contains("?$expand=ProviderPrivileges"))
                    mapRelatedType = "ProviderPrivileges";
                if (mapRelatedType.Contains("?$expand=VaProviderRelationships"))
                    mapRelatedType = "VaProviderRelationships";


                //Map Related Types switch
                switch (mapRelatedType)
                {
                    case "OwningOrganization":
                        //Lookup and Map the Single Site Owning Org(provider)
                        var ppmsOwningOrg =
                            context.AccountSet.FirstOrDefault(i => i.Id == ppmsCareSite.ppms_organization.Id);
                        var ppmsOwningOrgList = new List<Account> { ppmsOwningOrg };
                        careSite.OwningOrganization =
                            await ProviderMap.MapProviders(ppmsOwningOrgList, "None", context);
                        break;
                    case "SiteContact":
                        //Lookup and Map the Single Site Contact
                        var ppmsSiteContact =
                            context.ContactSet.FirstOrDefault(i => i.Id == ppmsCareSite.ppms_SiteContact.Id);
                        var ppmsSiteContactList = new List<Contact> { ppmsSiteContact };
                        careSite.SiteContact =
                            await ProviderContactsMap.MapProviderContacts(ppmsSiteContactList, "None", context);
                        break;

                    case "Providers":
                        //Lookup and Map the related Providers
                        var ppmsProviders =
                            context.AccountSet.Where(i => i.ppms_ownedcaresite.Id == ppmsCareSite.Id);
                        var ppmsProvidersList = ppmsProviders.ToList();
                        careSite.Providers =
                            await ProviderMap.MapProviders(ppmsProvidersList, "None", context);
                        break;

                    case "ProviderServices":
                        //Lookup and Map the related Provider Services
                        var ppmsProviderServices =
                            context.ppms_providerserviceSet.Where(i => i.ppms_caresite.Id == ppmsCareSite.Id);
                        var ppmsProviderServicesList = ppmsProviderServices.ToList();
                        careSite.ProviderServices =
                            await ProviderServicesMap.MapProviderServices(ppmsProviderServicesList, "None", context);
                        break;

                    case "ProviderPrivileges":
                        //Lookup and Map the Provider Privileges
                        var ppmsProviderPrivileges =
                            context.ppms_providerprivilegeSet.Where(i => i.ppms_CareSite.Id == ppmsCareSite.Id);
                        var ppmsProviderPrivilegesList = ppmsProviderPrivileges.ToList();
                        careSite.ProviderPrivileges =
                            await ProviderPrivilegesMap.MapProviderPrivileges(ppmsProviderPrivilegesList, "None", context);
                        break;

                    case "VaProviderRelationships":
                        //Lookup and Map the Va provider relationships
                        var ppmsVaProviderRelationships = context.ppms_vaproviderrelationshipSet.Where(i => i.ppms_CareSiteId.Id == ppmsCareSite.Id);
                        var ppmsVaProviderRelationshipsList = ppmsVaProviderRelationships.ToList();
                        if (ppmsVaProviderRelationshipsList.Any())
                        {
                            //Map Va Provider Relationships
                            careSite.VaProviderRelationships = await VaProviderRelationshipMap.MapVaProviderRelationships(ppmsVaProviderRelationshipsList, "None", context);
                        }
                        break;
                    default:
                        break;
                }

                careSites.Add(careSite);
            }
            return careSites.AsQueryable();
        }
        
    }
}